#version 330 core
out vec4 FragColor;

uniform vec2 u_resolution;
uniform float u_time;
vec3 rd;
float local_time;

float donut( vec3 p, vec2 t ) // originally sdTorus
{
	p.z = (u_time < 33 ? p.z : p.z / p.y);
	p.y = (u_time < 33 ? p.y : sin(t.y * 0.3));
	p.x = (u_time < 40 ? p.x : p.y);
	vec2 q = (u_time < 25 ? vec2(length(p.xz)-t.x, p.yy) : vec2(length(p.yx)-t.y, p.x));
  
  
  return length(q)-t.y;
}

float sphere(vec3 p, float radius)
{
	
	p = (u_time < 15 || u_time > 40 ? p / 2 : (sin((p * 0.3) + (cos(p))* 0.3)  ));
	return length(p)-radius;
}
	float box (vec3 p, vec3 c)
	{
		vec3 q = abs(p)-c;
		return min(0., max(q.x,max(q.y, q.z))) + length(max(q,0.));
	}


float map (vec3 p) 
{
	p = mod(p, 3.)-3.*0.5;
	
	return mix(sphere((p * 2), 0.5), donut(p, vec2(0.75)), sin(u_time)*0.5+0.5);
	
}

vec3 get_normal (vec3 p) 
{
	vec2 eps = vec2(0.001, 0.); 
	return normalize(vec3( map(p+eps.xyy) - map(p-eps.xyy),
						map(p+eps.yxy) - map(p-eps.yxy),
						map(p+eps.yyx) - map(p-eps.yyx)
							)
		); 
}

float diffuse_directional(vec3 n, vec3 l) 
{
	return dot(n, normalize(l))*.5+.5;
}

void main()
{
	local_time = u_time;

	vec2 uv = vec2(gl_FragCoord.x / u_resolution.x, gl_FragCoord.y / u_resolution.y);
	uv -= 0.5;
	uv /= vec2(u_resolution.y / u_resolution.x, 1);
	
	vec3 ro = vec3(0.2 * (u_time < 15 || u_time > 40 ? 1.0 : (sin(u_time / 2))), 0.3 * (u_time < 15 || u_time > 40 ? 1.0 : sin(u_time / 2)), -3. * (u_time < 15 || u_time > 40 ? 1.0 : sin(u_time / 3.14)));
	vec3 p = ro; 
	
	//vec3 rd = normalize(vec3(uv * (u_time < 20 || u_time > 37 ? 1.0 : (sin(-uv / 0.3))), 1.));
	vec3 rd = normalize(vec3(uv, 1.));
	
	vec3 color = vec3(0.);
	
	bool hit = false;
	float shading = 0.;
	
	for(float i = 0.; i < 95.; i++) // stop at 95
	{
		float d = map(p); 
		if(d<0.01)
		{
			hit = true; 
			shading = i / 95.; 
			
			break; 
		}
		p += d * rd ; 
	}
	
	float t = length(ro-p); 
	if (hit) 
	{
		vec3 n = get_normal(p);
		vec3 l = vec3(0.5, 2., (-2. * (sin(u_time))));
		color = mix(vec3(0.2, (sin(u_time)), 0.5), vec3(0.8, 0.5, 0.1), diffuse_directional(n,l));
	}
	else color = vec3(0., 0., 0.3); // if not, color it black
	
	
	if (local_time < 17)
	color = mix(color, vec3(0.1, 0.1, 0.1), 1.-exp(-0.01*t*t)); 
	else if (local_time >= 17 && local_time < 24)
	color = mix(color, vec3((sin(u_time) * 0.3), sin(u_time), sin(u_time)), 1.-exp(-0.01*(-t)*(-t))); 
	else
	color = mix(color, vec3(cos(u_time ), sin(u_time), sin(u_time)), (u_time < 19 ? 1.-exp(-0.01*t*t) : 0.03-exp(-0.07/t*t) )); 
	
	FragColor = vec4(color, 1.);
}
